//
//  QuartzFunViewController.m
//  QuartzFun
//
//  Created by Robert Górczyński on 11-07-22.
//

#import "QuartzFunViewController.h"
#import "QuartzFunView.h" 
#import "Constants.h" 

@implementation QuartzFunViewController
@synthesize colorControl; 

- (IBAction)changeColor:(id)sender { 
    UISegmentedControl *control = sender; 
    NSInteger index = [control selectedSegmentIndex]; 
	
    QuartzFunView *quartzView = (QuartzFunView *)self.view; 
	
    switch (index) { 
        case kRedColorTab: 
            quartzView.currentColor = [UIColor redColor]; 
            quartzView.useRandomColor = NO; 
            break; 
        case kBlueColorTab: 
            quartzView.currentColor = [UIColor blueColor]; 
            quartzView.useRandomColor = NO; 
            break; 
        case kYellowColorTab: 
            quartzView.currentColor = [UIColor yellowColor]; 
            quartzView.useRandomColor = NO; 
            break; 
        case kGreenColorTab:
            quartzView.currentColor = [UIColor greenColor]; 
            quartzView.useRandomColor = NO; 
            break; 
        case kRandomColorTab: 
            quartzView.useRandomColor = YES; 
            break; 
        default: 
            break; 
    } 
} 

- (IBAction)changeShape:(id)sender { 
    UISegmentedControl *control = sender; 
    [(QuartzFunView *)self.view setShapeType:[control 
											  selectedSegmentIndex]]; 
	
    if ([control selectedSegmentIndex] == kImageShape) 
        colorControl.hidden = YES; 
    else 
        colorControl.hidden = NO; 
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.colorControl = nil; 
    [super viewDidUnload]; 
}


- (void)dealloc {
    [colorControl release]; 
    [super dealloc];
}

@end
